import USB_Controller
import time
import struct

class Keysight_34465A(USB_Controller.USB_Controller):
    def __init__(self, hostname=None):
        USB_Controller.USB_Controller.__init__(self,hostname)

    def prepDCVoltageMeasurement(self, measure_range):
        self.command("CONF:VOLT:DC " + measure_range)
        self.command("TRIG:SOUR BUS")
        self.command("SAMP:COUN 1")
        self.command("INIT")

    def prepDCCurrentMeasurement(self, measure_range):
        self.command("CONF:CURR:DC " + measure_range)
        self.command("SENS:CURR:DC:TERM 10")
        self.command("TRIG:SOUR BUS")
        self.command("SAMP:COUN 1")
        self.command("INIT")

    def measure(self):
        self.command("*TRG")
        data = self.query("FETC?")
        self.command("INIT")
        return float(data)
